#!/usr/bin/env python
# -*- coding: utf-8 -*- 
#   Gimp-Python - allows the writing of Gimp plugins in Python.
#   Copyright (C) 1997  James Henstridge <james@daa.com.au>
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#   Wg. źródła http://www.gimp.org/docs/python/
#   Wtyczka jako Bump Map (nie w Python) dostarczna wraz z GIMP jest w menu: 
#   Filtery → Artystyczne → Przekształcenie w tkaninę 

from gimpfu import *  # mówi Pythonowi skąd ma załadować moduły GIMP 

def clothify(timg, tdrawable, bx=9, by=9, azimuth=135, elevation=45, depth=3):
#  procedurze przekazywane sa wartości, uzyskane z dialogu; timg i tdrawable
#  informują o tym, że będą wykorzystywane otwarty obraz i obszar roboczy
    width = tdrawable.width  # określamy szerokość i wysokość
    height = tdrawable.height 

    img = gimp.Image(width, height, RGB)  # tworzymy obraz
    img.disable_undo()  # na czas pracy programu wyłączamy możliwość redagowania
	# obrazu przez użytkownika

    layer_one = gimp.Layer(img, "X Dots", width, height, RGB_IMAGE,
                           100, NORMAL_MODE)  # tworzymy warstwę, jej nazwa będzie "X Dots"
    img.insert_layer(layer_one) # procedura poprawiona - warstwa dodawana do obrazu…
    pdb.gimp_edit_fill(layer_one, BACKGROUND_FILL)  # ...i wypełnia kolorem 

    pdb.plug_in_noisify(img, layer_one, 0, 0.7, 0.7, 0.7, 0.7)  # wykorzystujemy wtyczkę
	# o odpowiedniej nazwie i przekazujemy do niej parametry 

    layer_two = layer_one.copy()  # tworzymy jeszcze jedną warstwę - kopiowaniem
    layer_two.mode = MULTIPLY_MODE  # ustawiamy tryb warstwy
    layer_two.name = "Y Dots"  # ustalamy nazwę warstwy na "Y Dots"
    img.insert_layer(layer_two) # procedura poprawiona - warstwa dodawana do obrazu…

    pdb.plug_in_gauss_rle(img, layer_one, bx, 1, 0)  # wykorzystujemy wtyczkę Rozmycia Gauss
    pdb.plug_in_gauss_rle(img, layer_two, by, 0, 1)

    img.flatten()  # spłaszczamy wszystkie warstwy

    bump_layer = img.active_layer  # tworzymy zmienną z aktywnej warstwy

    pdb.plug_in_c_astretch(img, bump_layer)  # rozciągamy kontrast dla pokrycia max możliwego zakresu  
    pdb.plug_in_noisify(img, bump_layer, 0, 0.2, 0.2, 0.2, 0.2)
    pdb.plug_in_bump_map(img, tdrawable, bump_layer, azimuth,
                         elevation, depth, 0, 0, 0, 0, True, False, 0)

    gimp.delete(img)

register(
        "clothify", # Nazwa rejestrowanej wtyczki w Przeglądarce procedur, jeśli tak wpiszemy, oraz nazwa na krawędzi okna GUI 
	# GIMP doda prefiks "python-fu (lepiej prefiksu samemu nie dodawać).
        "Tworzy wygląd warstwy\n podobny do drukowania\n na płótnie ",  # Krótki opis działań wykonywanych przez 
		# wtyczkę, zobaczymy go po umieszczeniu wskaźnika myszki na nazwie punktu w menu.
        "Tworzy wygląd warstwy podobny do drukowania na płótnie ",  # Nazwa Dokumentacyjna, 
		# informacja o wtyczce, która pojawia się w Przeglądarce procedur, Dodatkowe informacje - 
		# wskazane wyjaśnić w bardziej szczegółowy sposób, co wtyczka robi.
        "James Henstridge, Modified Zbyma72age", # # Informacja o Autorze wtyczki
        "James Henstridge", # # Informacja o prawach Autorskich
        "1997-1999, Modified 2015",  # data utworzenia wtyczki
        "_Clothify (Mapa wypukłości)...",  # Etykieta
        "RGB*, GRAY*",  # Typ obrazu: z którym wtyczka może współpracować, przy tym oznaczeniu Nasza wtyczka obsługuje wszystkie 
		 # typy obrazów (ale przy tym oznaczeniu, bez obrazu Etykieta będzie wyszarzona), alternatywnie można "*". 
        [
            (PF_IMAGE, "image", "Input image", None),
            (PF_DRAWABLE, "drawable", "Input drawable", None),
            (PF_INT, "x-blur", "Rozmycie X", 9),  # parametry początkowe w oknie wtyczki
            (PF_INT, "y-blur", "Rozmycie Y", 9),
            (PF_INT, "azimuth", "Azymut", 135),
            (PF_INT, "elevation", "Wysokość", 45),
            (PF_INT, "depth", "Głębia", 3)
        ],
        [],
        clothify, menu="<Image>/TEST")  # Nazwa podana w def wywoływana 
	# Naszym kodem oraz Ścieżka do punktu menu GIMP-a, gdzie powinna się znajdować Etykieta wtyczki, 
	# używamy wielokropka ... w etykiecie otwierającej okno dialogowe wtyczki, 
	# (ścieżka do menu może startować z np. <Image> lub <Toolbox> czy <Layers>, wszędzie 
	# gdzie czujemy jej miejsce)  

main()